/*****************************************************************************
*  LPC15xx SCT demo
*
*  Use SCT3 L counter part to generate a 50 KHz PWM signal at SCT3_OUT0
*  LPC15xx - SCT0/1 support:  8 inputs
*                             10 outputs
*                             16 match/capture registers
*                             16 events
*                             16 states
*            SCT2/3 support:  3 inputs
*                             6 outputs
*                             8 match/capture registers
*                             10 events
*                             10 states
*****************************************************************************/
#include "LPC15xx.h"

void SCT3_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= (1 << 5);                // enable the SCT3 clock

    LPC_SCT3->CONFIG |= (1 << 17);                         // two 16-bit timers, auto limit
    LPC_SCT3->CTRL_L |= (SystemCoreClock/1000000-1) << 5;  // set prescaler, SCT clock = 1 MHz
                                              
    LPC_SCT3->MATCH[0].L    = 20-1;                        // match 0 @ 20/1MHz = 20 usec (50 KHz PWM freq)
    LPC_SCT3->MATCHREL[0].L = 20-1;
    LPC_SCT3->MATCH[1].L    = 5;                           // match 1 used for duty cycle (in 20 steps)
    LPC_SCT3->MATCHREL[1].L = 5;

    LPC_SCT3->EVENT[0].STATE = 0x00000001;                 // event 0 only happens in state 0
    LPC_SCT3->EVENT[0].CTRL  = (0 << 0)  |                 // MATCHSEL[3:0] = related to match 0
                               (1 << 12) |                 // COMBMODE[13:12] = match condition only
                               (1 << 14) |                 // STATELD[14] = STATEV is loaded into state
                               (0 << 15);                  // STATEV[15] = 0

    LPC_SCT3->EVENT[1].STATE = 0x00000001;                 // event 1 only happens in state 0
    LPC_SCT3->EVENT[1].CTRL  = (1 << 0)  |                 // MATCHSEL[3:0] = related to match 1
                               (1 << 12) |                 // COMBMODE[13:12] = match condition only
                               (1 << 14) |                 // STATELD[14] = STATEV is loaded into state
                               (0 << 15);                  // STATEV[15] = 0

    LPC_SCT3->OUT[0].SET = (1 << 0);                       // event 0 will set SCT3_OUT0
    LPC_SCT3->OUT[0].CLR = (1 << 1);                       // event 1 will clear SCT3_OUT0

    LPC_SCT3->CTRL_L    &= ~(1 << 2);                      // unhalt it by clearing bit 2 of CTRL reg
}
